/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.CustomDrawContext;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.systems.target.TargetSettings;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.render.Draw3DUtility;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import Krasnodar.rockstarnew.utility.render.Utils;
import Krasnodar.rockstarnew.utility.render.batching.impl.IconBatching;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@ModuleInfo(name="Arrows", category=ModuleCategory.VISUALS, desc="modules.descriptions.tracers")
public class Arrows
extends BaseModule {
    private final BooleanSetting lines = new BooleanSetting(this, "lines");
    private final SelectSetting targets = new SelectSetting((SettingsContainer)this, "modules.settings.tracers.targets", "modules.settings.tracers.targets.description");
    private final SelectSetting.Value players = new SelectSetting.Value(this.targets, "modules.settings.tracers.targets.players").select();
    private final SelectSetting.Value animals = new SelectSetting.Value(this.targets, "modules.settings.tracers.targets.animals");
    private final SelectSetting.Value mobs = new SelectSetting.Value(this.targets, "modules.settings.tracers.targets.mobs");
    private final SelectSetting.Value invisibles = new SelectSetting.Value(this.targets, "modules.settings.tracers.targets.invisibles").select();
    private final SelectSetting.Value nakedPlayers = new SelectSetting.Value(this.targets, "modules.settings.tracers.targets.naked_players").select();
    private final SelectSetting.Value friends = new SelectSetting.Value(this.targets, "modules.settings.tracers.targets.friends").select();
    private final Map<class_1297, ArrowsAnimation> animations = new HashMap<class_1297, ArrowsAnimation>();
    private boolean wasOnGround = true;
    private final EventListener<HudRenderEvent> onHud = event -> {
        if (Arrows.mc.field_1724 != null && Arrows.mc.field_1687 != null && !this.lines.isEnabled()) {
            CustomDrawContext context = event.getContext();
            class_4587 ms = context.method_51448();
            boolean isOnGround = Arrows.mc.field_1724.method_24828();
            if (this.wasOnGround && !isOnGround) {
                for (ArrowsAnimation animation : this.animations.values()) {
                    animation.jump.setValue(0.0f);
                }
            }
            this.wasOnGround = isOnGround;
            TargetSettings targetSettings = new TargetSettings.Builder().targetPlayers(this.players.isSelected()).targetAnimals(this.animals.isSelected()).targetInvisibles(this.invisibles.isSelected()).targetFriends(this.friends.isSelected()).targetNakedPlayers(this.nakedPlayers.isSelected()).targetMobs(this.mobs.isSelected()).build();
            HashSet<class_1297> toRemove = new HashSet<class_1297>();
            for (Map.Entry<class_1297, ArrowsAnimation> entry : this.animations.entrySet()) {
                class_1309 livingEntity;
                class_1297 entity = entry.getKey();
                ArrowsAnimation animation = entry.getValue();
                boolean shouldShow = Arrows.mc.field_1687.method_62145(entity) && entity instanceof class_1309 && targetSettings.isEntityValid((class_1297)(livingEntity = (class_1309)entity));
                animation.showing.update(shouldShow);
                animation.showing.setDuration(500L);
                if (shouldShow) {
                    double distance = Arrows.mc.field_1724.method_5739(entity);
                    float distanceProgress = (float)class_3532.method_15350((double)(1.0 - distance / 50.0), (double)0.0, (double)1.0);
                    animation.distance.update(distanceProgress);
                }
                animation.jump.update(1.0f);
                if (animation.showing.getValue() != 0.0f || shouldShow) continue;
                toRemove.add(entity);
            }
            for (class_1297 entity : Arrows.mc.field_1687.method_18112()) {
                class_1309 livingEntity;
                if (!(entity instanceof class_1309) || !targetSettings.isEntityValid((class_1297)(livingEntity = (class_1309)entity)) || this.animations.containsKey(entity)) continue;
                this.animations.put(entity, new ArrowsAnimation());
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.disableCull();
            ms.method_22903();
            IconBatching iconBatching = new IconBatching(class_290.field_1575, context.method_51448());
            ms.method_46416(sr.getScaledWidth() / 2.0f, sr.getScaledHeight() / 2.0f, 0.0f);
            for (Map.Entry<class_1297, ArrowsAnimation> arrow : this.animations.entrySet()) {
                if (!(arrow.getValue().showing.getValue() > 0.0f)) continue;
                float distanceOffset = arrow.getValue().distance.getValue() * 20.0f;
                float jumpOffset = (1.0f - arrow.getValue().jump.getValue()) * 10.0f;
                RenderUtility.rotate(ms, 0.0f, 0.0f, this.calculateAngle(arrow.getKey(), event.getTickDelta()));
                RenderUtility.scale(ms, 0.0f, 0.0f, 2.0f - arrow.getValue().showing.getValue());
                context.drawTexture(Rockstar.id("textures/arrow.png"), -10.0f, 40.0f - distanceOffset - jumpOffset, 20.0f, 20.0f, (Rockstar.getInstance().getFriendManager().isFriend(arrow.getKey().method_5477().getString()) ? Colors.GREEN : Colors.ACCENT).mulAlpha(arrow.getValue().showing.getValue()));
                RenderUtility.end(ms);
                RenderUtility.end(ms);
            }
            iconBatching.draw();
            for (class_1297 entityx : toRemove) {
                this.animations.remove(entityx);
            }
            ms.method_22909();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.disableDepthTest();
        }
    };
    private final EventListener<Render3DEvent> on3DRender = event -> {
        if (Arrows.mc.field_1724 != null && Arrows.mc.field_1687 != null && this.lines.isEnabled()) {
            class_4587 matrices = event.getMatrices();
            TargetSettings targetSettings = new TargetSettings.Builder().targetPlayers(this.players.isSelected()).targetAnimals(this.animals.isSelected()).targetInvisibles(this.invisibles.isSelected()).targetFriends(this.friends.isSelected()).targetNakedPlayers(this.nakedPlayers.isSelected()).targetMobs(this.mobs.isSelected()).build();
            RenderUtility.setupRender3D(false);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            for (class_1297 entity : Arrows.mc.field_1687.method_18112()) {
                class_1309 livingEntity;
                if (!(entity instanceof class_1309) || !targetSettings.isEntityValid((class_1297)(livingEntity = (class_1309)entity))) continue;
                class_243 entityPos = Utils.getInterpolatedPos((class_1297)livingEntity, event.getTickDelta());
                Draw3DUtility.renderLineFromPlayer(matrices, builder, entityPos.method_1031(0.0, (double)(livingEntity.method_17682() / 2.0f), 0.0), Colors.WHITE);
            }
            RenderUtility.buildBuffer(builder);
            RenderUtility.endRender3D();
        }
    };

    private float calculateAngle(class_1297 entity, float partialTicks) {
        class_243 pos = Utils.getInterpolatedPos(entity, partialTicks).method_1020(Arrows.mc.field_1773.method_19418().method_19326());
        double cos = class_3532.method_15362((float)((float)((double)Arrows.mc.field_1773.method_19418().method_19330() * (Math.PI / 180))));
        double sin = class_3532.method_15374((float)((float)((double)Arrows.mc.field_1773.method_19418().method_19330() * (Math.PI / 180))));
        double rotY = -(pos.field_1350 * cos - pos.field_1352 * sin);
        double rotX = -(pos.field_1352 * cos + pos.field_1350 * sin);
        return (float)(Math.atan2(rotY, rotX) * 180.0 / Math.PI - 90.0);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.wasOnGround = Arrows.mc.field_1724 != null && Arrows.mc.field_1724.method_24828();
    }

    static class ArrowsAnimation {
        Animation showing = new Animation(300L, Easing.BAKEK);
        Animation rotating = new Animation(300L, Easing.BAKEK);
        Animation distance = new Animation(200L, Easing.CUBIC_OUT);
        Animation jump = new Animation(300L, Easing.BAKEK);

        ArrowsAnimation() {
        }
    }
}

